
# Swift-FedGNN: Federated Graph Learning with Low Communication and Sample Complexities

## Supported datasets: 
* `ogbn-arxiv`
* `ogbn-products`
* `reddit`
* `citeseer`
* `flickr`
---

## Preparing the Data

**Partition the graph** with METIS.  
```bash
python data/partition_dataset.py --num_parts 10 --dataset reddit
```
This produces `partitioned_dataset/reddit_metis_10.bin`, which `train.py` will locate automatically.



---


## Quick Start

```bash
python train.py \
    --dataset reddit \
    --num_parts 10 \
    --partition_method metis \
    --device gpu \
    --fan_out 15,10 \
    --num_steps 4001 \
    --batch_size 256 \
    --lr 0.001 \
    --num_steps 5001 \
    --num_global_sample_clients_per_step 5 \
    --global_sample_interval 10 \
    --model_type graphsage
```

Logs are written to `output/metis_graphsage/log/`, checkpoints to `output/metis_graphsage/checkpoint/`.

### Switching GNN Models

* GraphSAGE (default): `--model_type graphsage`  
* GIN: `--model_type gin`

### Running Baselines

| Algorithm | Extra flag | Constraint |
|----------|------------|------------|
| **Swift-FedGNN** | None | None |
| **FEDGNN-G** | None | `--global_sample_interval` **must** be `1` |
| **LLCG** | `--baseline_llcg` | `--num_global_sample_clients_per_step` **must** be `1` |
| **FEDGNN-PNS**  | `--baseline_pns`  | None |


---

## Logging & Checkpoints

* **Client logs**: `output/<partition_method>_<model_type>/log/client_<k>.log`  
* **Validation log**: `output/<partition_method>_<model_type>/log/validation.log`  
* **Checkpoints**: `output/<partition_method>_<model_type>/checkpoint/model_step_<n>.pth`

